//##################################################################
//
// InitialDlg.cpp : Initial dialog for initialization
//
//##################################################################

#include "stdafx.h"
#include "SpeedDome.h"
#include "InitialDlg.h"
#include "misc.h"
#include "Comm.h"
#include "assert.h"
#include "define.h"
#include "GlobalVar.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


//-------------- User defined variable --------------------
#define		InitCom			1
#define		ScanBus			2
#define		ScanJoystick	3
//---------------------------------------------------------

/////////////////////////////////////////////////////////////////////////////
// CInitialDlg dialog


CInitialDlg::CInitialDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CInitialDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CInitialDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT

	Stage=0;
	Finished_InitCom=0;
	Finished_ScanBus=0;
	Finished_ScanJoystick=0;
}


void CInitialDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CInitialDlg)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CInitialDlg, CDialog)
	//{{AFX_MSG_MAP(CInitialDlg)
	ON_WM_CREATE()
	ON_WM_CLOSE()
	ON_WM_TIMER()
	ON_BN_CLICKED(IDC_INIT_INIT_COM, OnInitCom)
	ON_BN_CLICKED(IDC_INIT_SCAN_BUS, OnScanBus)
	ON_BN_CLICKED(IDC_INIT_SCAN_JOYSTICK, OnScanJoystick)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CInitialDlg message handlers


int CInitialDlg::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	if (CDialog::OnCreate(lpCreateStruct) == -1)
		return -1;
	// TODO: Add your specialized creation code here
	if ( !SetTimer(3,100,NULL) )
		{
		MessageBox("Error : SetTimer failed !");
		return -1;
		}

	return 0;
}

void CInitialDlg::OnClose() 
{
	// TODO: Add your message handler code here and/or call default
	KillTimer(3);
	DeleteObject(m_FlashCorp);

	CDialog::OnClose();
}

//##################################################################
//	OnInitDialog()
//##################################################################
BOOL CInitialDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	// TODO: Add extra initialization here
	//----------- Corp Bitmap --------------------------------
	LoadBitmapFromBMPFile("Flash_Corp.bmp",&m_FlashCorp,&m_hPalette);
	SendDlgItemMessage(IDC_BITMAP_CROP,STM_SETIMAGE,(WPARAM) IMAGE_BITMAP,(LPARAM)m_FlashCorp );
	//------------------------------------
	Progress_InitCom=(CProgressCtrl *) GetDlgItem(IDC_PROGRESS_INIT_INIT_COM);
	Progress_InitCom->SetRange(0,100);		Progress_InitCom->SetPos(0);
	
	Progress_ScanBus=(CProgressCtrl *) GetDlgItem(IDC_PROGRESS_INIT_SCAN_BUS);
	Progress_ScanBus->SetRange(0,256);		Progress_ScanBus->SetPos(0);

	Progress_ScanJoystick=(CProgressCtrl *)	GetDlgItem(IDC_PROGRESS_INIT_SCAN_JOYSTICK);
	Progress_ScanJoystick->SetRange(0,100);	Progress_ScanJoystick->SetPos(0);
	//-------------------------------------
	::SendMessage(m_hWnd,WM_COMMAND,IDC_INIT_INIT_COM,BN_CLICKED);


	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

//##################################################################
//	OnTimer()
//##################################################################
void CInitialDlg::OnTimer(UINT nIDEvent) 
{
int	PrePosition=0;
	// TODO: Add your message handler code here and/or call default
switch( Stage )
	{
	case InitCom:
			PrePosition=Progress_InitCom->OffsetPos(50);
			if( Finished_InitCom&&(PrePosition>=100) )
				{
				Stage=ScanBus;
				PostMessage(WM_COMMAND,IDC_INIT_SCAN_BUS,BN_CLICKED);
				}
			break;
	case ScanBus:
			PrePosition=Progress_ScanBus->OffsetPos(20);
			if( Finished_ScanBus&&(PrePosition>=100) )
				{
				PostMessage(WM_COMMAND,IDC_INIT_SCAN_JOYSTICK,BN_CLICKED);
				Stage=ScanJoystick;
				}
			break;
	case ScanJoystick:	
			PrePosition=Progress_ScanJoystick->OffsetPos(20);
			if( Finished_ScanJoystick&&(PrePosition>=100) )
				{
				PostMessage(WM_COMMAND,IDOK,BN_CLICKED);
				Stage=0;
				}
			break;
	}

	CDialog::OnTimer(nIDEvent);
}

//##################################################################
//	OnInitCom()
//##################################################################
void CInitialDlg::OnInitCom() 
{
	// TODO: Add your control notification handler code here
	Stage=InitCom;
	S_COM_Init();
	//------ Initial (checked)
	CWnd *ptr=GetDlgItem(IDC_CHECK_INIT_COM);
	::SendMessage(ptr->m_hWnd,BM_SETCHECK,BST_CHECKED,0);

	Finished_InitCom=1;
}

//##################################################################
//	OnScanBus()
//##################################################################
void CInitialDlg::OnScanBus() 
{
// TODO: Add your control notification handler code here
DWORD			NumberOfBytesWritten,NumberOfBytesRead;
unsigned char	Buffer[6]={'\xff','\xff','\xff','\xff','\xff','\xff'};
char			Packet[6]={'\x0','\x0','\x0','\x0','\x0','\x0'};
unsigned		Checksum;
unsigned char	MotorType,CameraType;

//----- Scan Bus checked -----------------------------
CWnd *ptr=GetDlgItem(IDC_CHECK_SCAN_BUS);
::SendMessage(ptr->m_hWnd,BM_SETCHECK,BST_CHECKED,0);

//-----------------------------------------------------
DomeNumOnBus=0;
for (	unsigned int i=0;i<=(AVL_NUM_DOME-1);i++	)
	{
	Packet[0]=i;
	Packet[5]=(((Packet[0]^Packet[1])^Packet[2] )^Packet[3])^Packet[4];

	CComm::RTS_WriteReadFile(hcom,Packet,6,&NumberOfBytesWritten,NULL,
					Buffer,&NumberOfBytesRead,G_DelayTime);

	Checksum=(((Buffer[0]^Buffer[1])^Buffer[2] )^Buffer[3])^Buffer[4];
	Sleep(5);
	
	#ifdef OFFLINE		//----- Offline Test
		{
		DomeIDOnBus[DomeNumOnBus]=i;
		Buffer[1]='\xff';
		DomeNumOnBus++;
		}
	#endif
	#ifndef OFFLINE		//----- On-Line Test
	if ( (Buffer[1]==i)&&(Buffer[0]==PC_ID)&&(Checksum==Buffer[5]) )
		{
		DomeIDOnBus[DomeNumOnBus]=Buffer[1];
		//---
		CComm::S_COM_ReadDomeType(Buffer[1],&MotorType,&CameraType);
		//---
		DomeType[DomeNumOnBus]=MotorType;
		Buffer[1]='\xff';
		DomeNumOnBus++;
		}
	#endif				//----- End

	Progress_ScanBus->OffsetPos(1);
	}
//-----------------------------------------------------
Finished_ScanBus=1;
}

//##################################################################
//	OnScanJoystick()
//##################################################################
void CInitialDlg::OnScanJoystick() 
{
	// TODO: Add your control notification handler code here

	//------ Scan Joystick checked -----------------------
	CWnd *ptr=GetDlgItem(IDC_CHECK_SCAN_JOYSTICK);
	::SendMessage(ptr->m_hWnd,BM_SETCHECK,BST_CHECKED,0);

	Finished_ScanJoystick=1;
}


//####################################################################
//	S_DomeInit()
//####################################################################
void CInitialDlg::S_COM_Init()
{
COMMTIMEOUTS	CommTimeouts;
DCB				Y_ComDCB={0};
DWORD			dwVersion;

CComm::S_GetSetting(ComPort,&AVL_NUM_DOME,&RTS);

//--------------------------------------------------------
dwVersion = ::GetVersion();	// Get the Windows version.

if (dwVersion < 0x80000000)                
    OS_VER=1;				// Windows NT/2000
else 
	OS_VER=0;				// Windows 98
//----------------------------------------------------------
hcom=CreateFile(ComPort,GENERIC_READ|GENERIC_WRITE,
				0,NULL,
				OPEN_EXISTING,
				FILE_ATTRIBUTE_NORMAL|FILE_FLAG_NO_BUFFERING,
				NULL);

Y_ComDCB.DCBlength = sizeof (DCB);
GetCommState(hcom,&Y_ComDCB);
SetupComm(hcom,6,6);
	Y_ComDCB.BaudRate=9600;
	Y_ComDCB.fBinary=TRUE;
	Y_ComDCB.fParity=TRUE;
	Y_ComDCB.fOutxCtsFlow = FALSE;
	Y_ComDCB.fOutxDsrFlow = FALSE;
	Y_ComDCB.fDtrControl = DTR_CONTROL_DISABLE;
	Y_ComDCB.fDsrSensitivity = FALSE;
	Y_ComDCB.fTXContinueOnXoff = TRUE;
	Y_ComDCB.fOutX = FALSE;
	Y_ComDCB.fInX = FALSE;
	Y_ComDCB.fErrorChar = FALSE;
	Y_ComDCB.fNull = FALSE;
	Y_ComDCB.fRtsControl=RTS_CONTROL_TOGGLE;//RTS_CONTROL_TOGGLE;
	Y_ComDCB.ByteSize=8;
	Y_ComDCB.Parity = NOPARITY;
	Y_ComDCB.StopBits=ONESTOPBIT;
//-- Configure the port according to the specifications of the DCB structure
SetCommState(hcom,&Y_ComDCB);
//-- Retrieve the time-out parameters for all read and write operations on the port. 
GetCommTimeouts(hcom,&CommTimeouts);
	CommTimeouts.ReadIntervalTimeout=4;				//-- 1ms
	CommTimeouts.ReadTotalTimeoutMultiplier=1;
	CommTimeouts.ReadTotalTimeoutConstant=15;
	CommTimeouts.WriteTotalTimeoutConstant=15;
	CommTimeouts.WriteTotalTimeoutMultiplier=1;
//-- Set the time-out parameters for all read and write operations on the port. 
SetCommTimeouts(hcom,&CommTimeouts);

}



